<?php defined( 'ABSPATH' ) OR die( 'This script cannot be accessed directly.' );

function cs_uwac_welcome_page(){
    $plugin_name    = 'Ultimate WhatsApp Chat';
    $plugin_uri     = 'ultimate-whatsapp-chat-for-wordpress';
    $plugin_version = UWAC_VERSION;
	?>
	<div class="wrap cs-plugin-home">
        <h1><?=$plugin_name?> <?php _e('Welcome Page', 'uwac'); ?></h1>
		<div class="cs-header">
            <div class="cs-header__title">
                <h2><?php echo sprintf( __( 'Welcome to <strong>%s</strong>', 'uwac' ), $plugin_name .' '. $plugin_version ) ?></h2>
            </div>
            <div class="cs-header__content">
                <div class="cs-header__links">
                    <div class="cs-header__link">
                        <i class="cli cli-help-circle"></i>
                        <a href="<?= CS_UWAC_PLUGIN_URL . '/docs/'; ?>" target="_blank"><?php _e('Online Documentation','uwac') ?></a>
                    </div>
                    <div class="cs-header__link">
                        <i class="cli cli-life-buoy"></i>
                        <a href="<?= CS_UWAC_SUPPORT_URL; ?>" target="_blank"><?php _e('Support Portal','uwac') ?></a>
                    </div>
                    <div class="cs-header__link">
                        <i class="cli cli-rotate-ccw"></i>
                        <a href="<?= CS_UWAC_SUPPORT_URL . '/change-log/'; ?>" target="_blank"><?php _e('Plugin Changelog','uwac') ?></a>
                    </div>
                </div>
                <div class="cs-header__about-text">
                    <?php _e("First off all, thanks for choosing us! we really love you! We made this plugin with all our heart, taking care of every small detail so you can entirely focus on creating great things with it. We sincerely hope you'll enjoy it the same as we do!",'uwac'); ?>
                </div>
            </div>
		</div>

		<div class="cs-features">
            <div class="one-third">
                <h4><i class="cli cli-help-circle"></i><?php _e('Help your customers easily','uwac') ?></h4>
				<p><?php _e('Now you have the possibility to help your clients in all the pages of your site (frontend and admin area included), adding as many chat widgets as you want, choosing the agents that will be available to help and with a nice and easy to use interface.','uwac'); ?></p>
				<a class="button cs-button" href="admin.php?page=cs-uwac#floating_widget"><?php _e( 'Start Creating Chat Widgets','uwac') ?></a>
            </div>
			<div class="one-third">
				<h4><i class="cli cli-droplet"></i><?php _e('Maximum customization!','uwac') ?></h4>
				<p><?php _e('Customize everything to fit your needs. Change the predefined messages, add the agents you want, choose one of our available themes and change their colors and much more! Now it\'s your turn ;)','uwac'); ?></p>
			</div>
			<div class="one-third">
				<h4><i class="cli cli-life-buoy"></i><?php _e('We support you!','uwac'); ?></h4>
				<p><?php _e('Do you have questions or suggestions? Feel free to contact us through our official website or via our Envato profile. We are available to help you!','uwac'); ?></p>
				<a class="button cs-button" href="<?= CS_UWAC_SUPPORT_URL . '/contact/'; ?>" target="_blank"><?php _e( 'Go to Contact page','uwac') ?></a>
			</div>
		</div>
	</div>
	<?php
}
